@extends('layouts.master')

@section('title')
    لوحة التحكم
@endsection

@section('first-css')
@endsection

@section('content-body')
    <!--**********************************
                        Content body start
                    ***********************************-->
    @include('massages')
    @if (Auth::user()->role == 0)
        @include('admin.dashboard')
    @elseif(Auth::user()->role == 1)
        @include('trainer.dashboard')
    @else
        <!--**********************************
                        Content body end
                    ***********************************-->


        <div class="container">
            <div class="" style="min-height: 828px;">
                <div class="container-fluid">
                    <div class="row">
                        @isset($exams)
                            @foreach ($exams as $exam)
                            @isset($exam)
                            <div class="col-xl-4">
                                <div class="card text-white bg-success">
                                    <div class="card-header">
                                        <h5 class="card-title text-white">إختبار - @isset($exam->type)
                                            {{$examTypes[$exam->type]}}
                                        @endisset</h5>
                                    </div>
                                    <div class="card-body mb-0">
                                        <a href="{{route('exam_show',$exam->id)}}" class="btn bg-white text-success light btn-card fw-bolde">دخول الاختبار</a>
                                    </div>
                                    
                                </div>
                            </div>
                            @endisset
                            @endforeach
                        @endisset
                    </div>
                </div>
            </div>

        </div>
    @endif
@endsection

@section('script')
    <script>
        $(document).ready(function() {
            $('table.display').DataTable();
        });
    </script>
    <script src="{{ asset('/vendor/datatables/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('/js/plugins-init/datatables.init.js') }}"></script>
@endsection
